import type { CurrentEnemy } from '../../game/enemy/battle';
export interface ToShowEnemy extends CurrentEnemy {
    critical: string;
    criticalDam: string;
    defDam: string;
    /** [名称, 描述, 颜色] */
    special: [string, string, string][];
    damageColor: string;
    showSpecial: [string, string, string][];
    damage: string;
}
interface BookDetailInfo {
    /** 怪物手册详细信息展示的怪物 */
    enemy?: ToShowEnemy;
    /** 怪物手册的怪物详细信息的初始位置 */
    pos?: number;
}
export declare const detailInfo: BookDetailInfo;
/**
 * 获取怪物的特殊技能描述
 * @param enemy 怪物实例
 */
export declare function getSpecialHint(enemy: ToShowEnemy): JSX.Element;
/**
 * 获得怪物的最近100个加防减伤
 * @param enemy 怪物实例
 */
export declare function getDefDamage(enemy: ToShowEnemy, addDef?: number, addAtk?: number): [number, number][];
/**
 * 获取怪物的临界信息
 * @param enemy 怪物实例
 */
export declare function getCriticalDamage(enemy: ToShowEnemy, addAtk?: number, addDef?: number): [number, number][];
export {};
